#pragma once

/**
 * @defgroup Services Services
 * OPC UA services as free functions.
 * Functions are overloaded for both Server and Client.
 * @see https://reference.opcfoundation.org/Core/Part4/v105/docs/
 */

#include "open62541pp/services/Attribute.h"
#include "open62541pp/services/Method.h"
#include "open62541pp/services/MonitoredItem.h"
#include "open62541pp/services/NodeManagement.h"
#include "open62541pp/services/Subscription.h"
#include "open62541pp/services/View.h"

/**
 * OPC UA services as free functions.
 */
namespace opcua::services {}
