#ifndef CERTIFICATES_H_
#define CERTIFICATES_H_

#include <open62541/types.h>

_UA_BEGIN_DECLS

#define KEY_DER_LENGTH 1193
UA_Byte KEY_DER_DATA[1193] = {
    0x30, 0x82, 0x04, 0xa5, 0x02, 0x01, 0x00, 0x02, 0x82, 0x01, 0x01, 0x00, 0xe0, 0xc9, 0x91, 0x62, 
    0xcd, 0x91, 0x68, 0x75, 0x2c, 0x32, 0x7a, 0xdd, 0xf1, 0xd6, 0x64, 0x77, 0x8b, 0x72, 0x9e, 0x14, 
    0x2a, 0x62, 0x08, 0xd1, 0x89, 0x7d, 0xe2, 0x17, 0xdc, 0xb3, 0xda, 0xbc, 0x3a, 0x9f, 0x84, 0x03, 
    0xd3, 0x2e, 0x68, 0xbe, 0xc1, 0x57, 0xcb, 0x2a, 0xe2, 0xd6, 0xcf, 0xc4, 0x7f, 0xbd, 0x53, 0x3f, 
    0xeb, 0x39, 0x98, 0x69, 0xb0, 0x40, 0x14, 0xbf, 0xf5, 0x5a, 0x23, 0x23, 0xf4, 0x4c, 0xf8, 0xf1, 
    0x03, 0x56, 0x6d, 0x7d, 0x1b, 0x93, 0xd7, 0x0f, 0xc1, 0x8c, 0x70, 0xe0, 0x2c, 0x55, 0x7e, 0xa1, 
    0xfc, 0x05, 0xe9, 0xd7, 0xea, 0xb1, 0x5c, 0x0f, 0x9b, 0xac, 0x6a, 0x2e, 0xb4, 0xc5, 0xbf, 0x41, 
    0x8f, 0xda, 0xfc, 0x85, 0xc6, 0xaa, 0x25, 0xe4, 0xb9, 0x9a, 0xc6, 0xd8, 0x9a, 0x31, 0x8a, 0x17, 
    0x8b, 0x8c, 0x4e, 0x20, 0xd9, 0x71, 0xfc, 0x66, 0x3a, 0xfd, 0x49, 0x95, 0x54, 0xa8, 0xaf, 0x42, 
    0x5e, 0xba, 0x26, 0xe6, 0xd3, 0xa0, 0xd2, 0x02, 0x3b, 0x51, 0x8b, 0x39, 0xd3, 0x97, 0xd2, 0xe4, 
    0xd1, 0x01, 0x65, 0xab, 0x8e, 0xa2, 0x80, 0x5b, 0x5e, 0xbb, 0x11, 0x7f, 0x50, 0x1b, 0x2b, 0x0d, 
    0x20, 0x40, 0xb5, 0xbf, 0xd1, 0x32, 0xfa, 0x25, 0xe1, 0x0d, 0x75, 0xfc, 0x11, 0xcf, 0x21, 0xdd, 
    0x45, 0x16, 0xe4, 0x56, 0x58, 0x49, 0x33, 0xca, 0xaf, 0xe3, 0x17, 0x7b, 0x7a, 0x8f, 0xb1, 0xec, 
    0x1c, 0x4d, 0xa2, 0xc2, 0xce, 0x8b, 0x19, 0x4b, 0xc0, 0xc4, 0x36, 0x6a, 0x7c, 0x5b, 0x89, 0x14, 
    0x98, 0xcb, 0xa9, 0xca, 0x66, 0xf2, 0xaa, 0xf9, 0x12, 0x40, 0x0e, 0x6a, 0x78, 0x4d, 0x1f, 0x54, 
    0x3c, 0x03, 0x7a, 0x91, 0xf5, 0xb7, 0x3d, 0xe2, 0xfc, 0x65, 0xb7, 0xaa, 0xa9, 0x39, 0x68, 0xa7, 
    0xdb, 0x29, 0xc1, 0x40, 0x0b, 0x4e, 0xfb, 0xce, 0x74, 0xa5, 0x46, 0xb9, 0x02, 0x03, 0x01, 0x00, 
    0x01, 0x02, 0x82, 0x01, 0x01, 0x00, 0xb4, 0xc8, 0x07, 0x60, 0x01, 0xd9, 0xb6, 0xbb, 0xbd, 0x8e, 
    0xdf, 0x97, 0xcd, 0xde, 0x51, 0xb0, 0x7e, 0xfa, 0xf0, 0x3d, 0x61, 0x94, 0xb4, 0x68, 0xe8, 0x7d, 
    0xd0, 0x2e, 0xc6, 0xb5, 0xf2, 0xed, 0xbc, 0xeb, 0xfb, 0x3d, 0x24, 0x43, 0x47, 0xc4, 0x5a, 0x34, 
    0x64, 0x56, 0x1a, 0x57, 0x0e, 0x83, 0x87, 0x04, 0x59, 0x86, 0xa7, 0x84, 0x0b, 0x9a, 0xbc, 0x3f, 
    0xdd, 0x30, 0x40, 0x7f, 0x7c, 0x91, 0x76, 0xf1, 0xcc, 0xa7, 0xf0, 0xba, 0x3a, 0x96, 0x0a, 0x6e, 
    0xcc, 0xe0, 0x84, 0x15, 0x91, 0xd6, 0x08, 0x71, 0xbd, 0xc5, 0x42, 0xad, 0xf2, 0xd2, 0x4e, 0x92, 
    0xd3, 0x6a, 0x4e, 0x15, 0xcc, 0xd3, 0xc1, 0x58, 0xe4, 0x27, 0x33, 0x2d, 0xb8, 0x37, 0x52, 0x7e, 
    0x16, 0xb9, 0xab, 0xb7, 0xd9, 0xc1, 0xeb, 0xc8, 0x79, 0xb9, 0xd3, 0xe6, 0x44, 0x13, 0x51, 0x2d, 
    0xc6, 0x02, 0xe5, 0xe0, 0x3c, 0xa3, 0x15, 0x9b, 0x49, 0xae, 0x85, 0xbe, 0x8c, 0x84, 0xf9, 0x87, 
    0x5d, 0x91, 0x9e, 0xf4, 0xf9, 0xf2, 0x8d, 0x81, 0x77, 0x7c, 0xfc, 0x60, 0x09, 0x48, 0x43, 0x2e, 
    0xbb, 0xaf, 0xc9, 0xd6, 0x90, 0x2d, 0x40, 0x80, 0x59, 0xbd, 0x3b, 0x04, 0xda, 0x50, 0x2a, 0x53, 
    0xf5, 0xc0, 0x97, 0x54, 0x04, 0x14, 0xb1, 0x8e, 0xd1, 0x6b, 0x53, 0x9e, 0xa4, 0xaa, 0x5e, 0x6e, 
    0x1c, 0x11, 0x6b, 0x0a, 0xc4, 0xec, 0x5b, 0x77, 0xa8, 0x00, 0x83, 0x77, 0xdb, 0xf4, 0xfb, 0x00, 
    0xf4, 0x06, 0x57, 0x25, 0x8e, 0x1c, 0x87, 0xb4, 0xbe, 0xb8, 0x04, 0x35, 0x93, 0x67, 0xaa, 0x36, 
    0xa5, 0x62, 0xe4, 0xf6, 0xcb, 0xc8, 0xa6, 0x58, 0x77, 0x96, 0xc4, 0x6c, 0x0b, 0xc8, 0x41, 0xe2, 
    0x36, 0x01, 0x94, 0xa5, 0xe9, 0x46, 0x17, 0xd3, 0x0b, 0x18, 0x7e, 0x06, 0x88, 0x9b, 0x7e, 0xdd, 
    0x92, 0x20, 0xc6, 0xe3, 0x7e, 0xb1, 0x02, 0x81, 0x81, 0x00, 0xf5, 0xa6, 0xda, 0x32, 0xb9, 0x37, 
    0x61, 0xe9, 0x7c, 0x99, 0xf7, 0x4a, 0x37, 0xee, 0x52, 0x30, 0x4f, 0xbf, 0x57, 0x6f, 0xfe, 0x20, 
    0xdc, 0xa3, 0xfe, 0x51, 0xbf, 0x72, 0x13, 0x8a, 0xb1, 0xd7, 0x99, 0x7d, 0x67, 0xa8, 0xd4, 0xb0, 
    0x35, 0x40, 0x7c, 0xc8, 0xdc, 0x03, 0x6b, 0x90, 0xb5, 0x65, 0x04, 0x7f, 0x97, 0x8b, 0xa8, 0x69, 
    0x20, 0x04, 0xcb, 0x48, 0x39, 0xb7, 0x57, 0xe0, 0xd9, 0xbb, 0x15, 0xe1, 0x59, 0x16, 0xf3, 0xe1, 
    0xab, 0x91, 0xea, 0x8a, 0x88, 0xad, 0x8d, 0xa3, 0x24, 0x4a, 0x35, 0xa5, 0xd2, 0x32, 0x19, 0x66, 
    0xa8, 0xbb, 0x32, 0x9d, 0xf4, 0x94, 0x99, 0xc1, 0x2e, 0x2b, 0xf8, 0x98, 0x6a, 0x6e, 0x72, 0x77, 
    0xd0, 0xc9, 0xfc, 0x5f, 0xd7, 0x69, 0xd1, 0x08, 0x12, 0xbf, 0x81, 0xc1, 0xa1, 0x1b, 0x3b, 0x41, 
    0xb0, 0x24, 0x11, 0x0a, 0x65, 0xab, 0x81, 0x39, 0xb3, 0xd5, 0x02, 0x81, 0x81, 0x00, 0xea, 0x41, 
    0xb5, 0xed, 0xac, 0xa0, 0x43, 0xd7, 0xde, 0x1e, 0x6b, 0x95, 0xbe, 0x88, 0x02, 0xaf, 0x2f, 0xbb, 
    0x37, 0xf7, 0x2f, 0xf6, 0x4f, 0xa0, 0xaa, 0x43, 0x03, 0x7d, 0x33, 0xdd, 0x1e, 0x7a, 0xba, 0xa0, 
    0x10, 0x77, 0x1f, 0x4a, 0xc9, 0x88, 0x58, 0x9d, 0x81, 0x3a, 0xe8, 0xac, 0x86, 0x2f, 0x80, 0x6c, 
    0xc7, 0xa0, 0xe5, 0xed, 0x8d, 0x90, 0xa9, 0xa7, 0x36, 0x23, 0xd7, 0xb5, 0x89, 0xfc, 0xad, 0x4d, 
    0xae, 0x0e, 0xec, 0xdc, 0xe7, 0x7e, 0x69, 0xfe, 0x62, 0x4b, 0x81, 0xfe, 0x52, 0x81, 0x77, 0x6a, 
    0x35, 0xab, 0x52, 0x6f, 0x56, 0x41, 0x6c, 0x57, 0x3d, 0x75, 0x92, 0x14, 0x42, 0xa2, 0xc9, 0x50, 
    0x52, 0x57, 0x9f, 0x26, 0x3c, 0xcd, 0x61, 0xa9, 0xda, 0x9b, 0x2c, 0xda, 0xc1, 0xd0, 0x26, 0x07, 
    0x90, 0x15, 0x8c, 0x81, 0xe2, 0xde, 0xc0, 0x98, 0x58, 0x9d, 0x96, 0x0f, 0xcd, 0x55, 0x02, 0x81, 
    0x81, 0x00, 0x87, 0xfb, 0xf8, 0x77, 0xf1, 0xcd, 0xf5, 0xb6, 0xa1, 0xd2, 0x3d, 0x71, 0x69, 0x6a, 
    0xd5, 0x36, 0x87, 0x3e, 0xdd, 0xb1, 0x52, 0x55, 0x70, 0xae, 0x9b, 0x9f, 0x37, 0x42, 0x78, 0x0c, 
    0xe4, 0x0b, 0xfc, 0x9c, 0xce, 0x20, 0x48, 0xb4, 0xce, 0x95, 0xc7, 0x3e, 0x0d, 0x85, 0x1b, 0x2b, 
    0x7d, 0x2e, 0xd1, 0x81, 0xac, 0x2b, 0x94, 0x6b, 0xb5, 0x5c, 0xd2, 0x07, 0x46, 0x63, 0xf7, 0x12, 
    0xb2, 0x94, 0xfd, 0x34, 0xc4, 0xf3, 0x8e, 0xc8, 0x13, 0x08, 0xf0, 0x74, 0x05, 0xdb, 0x45, 0x37, 
    0xd5, 0x63, 0xfb, 0x34, 0xb3, 0x1a, 0x26, 0xb3, 0x8c, 0x9e, 0x2c, 0x14, 0x02, 0x8b, 0xac, 0x5d, 
    0xa3, 0x28, 0x96, 0x32, 0x11, 0x60, 0xd8, 0x9e, 0xf9, 0x06, 0x87, 0x5d, 0xaa, 0xca, 0x99, 0xfb, 
    0x45, 0x1d, 0x9c, 0x3f, 0xca, 0xe6, 0x5f, 0x34, 0x2a, 0xc4, 0x9c, 0x66, 0x4c, 0x07, 0xd7, 0xbe, 
    0x50, 0x8d, 0x02, 0x81, 0x80, 0x51, 0xdb, 0x96, 0x6c, 0x30, 0x37, 0x6c, 0x9d, 0xa1, 0x43, 0x76, 
    0x0a, 0xc4, 0xa2, 0x98, 0x75, 0x89, 0x33, 0x5d, 0xd2, 0x25, 0xd3, 0x67, 0x6d, 0xd8, 0x31, 0x44, 
    0xa5, 0xda, 0x9a, 0xb9, 0x0c, 0xdf, 0xec, 0x10, 0xf4, 0xdf, 0x5d, 0x6d, 0xe1, 0x14, 0x3e, 0x2d, 
    0xab, 0x5d, 0x24, 0xf4, 0x5a, 0xe3, 0x00, 0xa0, 0x1d, 0x8c, 0x5b, 0x1f, 0x6d, 0xde, 0xaa, 0xcc, 
    0x93, 0x67, 0xcc, 0x4b, 0x24, 0x9d, 0x96, 0x98, 0x6d, 0x24, 0xbd, 0xe8, 0xb2, 0xd6, 0xed, 0x0a, 
    0x82, 0x22, 0x31, 0xb1, 0xb9, 0x05, 0xf6, 0x7a, 0x3c, 0x9c, 0xb8, 0xc5, 0x26, 0x65, 0x6a, 0x72, 
    0xd2, 0x83, 0xb2, 0x4a, 0xba, 0xc1, 0xa8, 0x2c, 0xad, 0xeb, 0xb2, 0x1b, 0xeb, 0x14, 0xe6, 0x9a, 
    0xba, 0x40, 0xc9, 0x4c, 0x92, 0xa4, 0xc7, 0x5d, 0xc4, 0xf9, 0xed, 0x65, 0x4e, 0xbb, 0x74, 0x40, 
    0xfb, 0x08, 0x36, 0x0b, 0x65, 0x02, 0x81, 0x81, 0x00, 0xeb, 0x60, 0x01, 0x21, 0x22, 0xa1, 0xde, 
    0x89, 0x62, 0xfa, 0x68, 0x03, 0x09, 0xf1, 0xa6, 0x14, 0xf0, 0xbe, 0xf7, 0x71, 0x3a, 0x01, 0x85, 
    0x1f, 0x2c, 0x86, 0xde, 0x4a, 0xfb, 0x35, 0x16, 0xc4, 0x84, 0x22, 0x83, 0x49, 0xeb, 0x0d, 0xf7, 
    0x33, 0x47, 0x8f, 0x96, 0x37, 0x32, 0xd3, 0xd2, 0xec, 0xea, 0x0f, 0xd0, 0xde, 0x0d, 0x27, 0x9e, 
    0xc1, 0xf1, 0xe0, 0x39, 0xa6, 0x3e, 0x6c, 0xd4, 0x39, 0xdf, 0xde, 0xbd, 0x4c, 0xb8, 0xe7, 0xb7, 
    0x4e, 0x2a, 0x32, 0x92, 0x83, 0xd3, 0x12, 0xb9, 0xa1, 0x91, 0x52, 0x46, 0x24, 0x58, 0x05, 0x35, 
    0x22, 0x5f, 0x10, 0x3c, 0x13, 0x5b, 0xbe, 0x47, 0x5e, 0xbf, 0x85, 0xd6, 0xac, 0xfc, 0xbb, 0xd9, 
    0x91, 0xf9, 0x50, 0x8f, 0xfc, 0xc2, 0x2c, 0x81, 0x5c, 0xa5, 0xc3, 0xc2, 0x15, 0xbe, 0xf4, 0x72, 
    0xfd, 0x4d, 0xf0, 0x10, 0x6f, 0xe5, 0xbf, 0x8c, 0xb1  
    };

#define CERT_DER_LENGTH 968
UA_Byte CERT_DER_DATA[968] = {
    0x30, 0x82, 0x03, 0xc4, 0x30, 0x82, 0x02, 0xac, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x09, 0x00, 
    0xa7, 0x17, 0x44, 0x2f, 0x8e, 0x6b, 0x74, 0xba, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 
    0xf7, 0x0d, 0x01, 0x01, 0x0b, 0x05, 0x00, 0x30, 0x39, 0x31, 0x0b, 0x30, 0x09, 0x06, 0x03, 0x55, 
    0x04, 0x06, 0x13, 0x02, 0x44, 0x45, 0x31, 0x12, 0x30, 0x10, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x0c, 
    0x09, 0x6f, 0x70, 0x65, 0x6e, 0x36, 0x32, 0x35, 0x34, 0x31, 0x31, 0x16, 0x30, 0x14, 0x06, 0x03, 
    0x55, 0x04, 0x03, 0x0c, 0x0d, 0x6f, 0x70, 0x65, 0x6e, 0x36, 0x32, 0x35, 0x34, 0x31, 0x2e, 0x6f, 
    0x72, 0x67, 0x30, 0x1e, 0x17, 0x0d, 0x31, 0x38, 0x30, 0x33, 0x32, 0x38, 0x30, 0x38, 0x33, 0x33, 
    0x35, 0x37, 0x5a, 0x17, 0x0d, 0x32, 0x38, 0x30, 0x33, 0x32, 0x35, 0x30, 0x38, 0x33, 0x33, 0x35, 
    0x37, 0x5a, 0x30, 0x45, 0x31, 0x0b, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x44, 
    0x45, 0x31, 0x12, 0x30, 0x10, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x0c, 0x09, 0x6f, 0x70, 0x65, 0x6e, 
    0x36, 0x32, 0x35, 0x34, 0x31, 0x31, 0x22, 0x30, 0x20, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x19, 
    0x6f, 0x70, 0x65, 0x6e, 0x36, 0x32, 0x35, 0x34, 0x31, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x40, 
    0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x68, 0x6f, 0x73, 0x74, 0x30, 0x82, 0x01, 0x22, 0x30, 0x0d, 0x06, 
    0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x01, 0x05, 0x00, 0x03, 0x82, 0x01, 0x0f, 
    0x00, 0x30, 0x82, 0x01, 0x0a, 0x02, 0x82, 0x01, 0x01, 0x00, 0xe0, 0xc9, 0x91, 0x62, 0xcd, 0x91, 
    0x68, 0x75, 0x2c, 0x32, 0x7a, 0xdd, 0xf1, 0xd6, 0x64, 0x77, 0x8b, 0x72, 0x9e, 0x14, 0x2a, 0x62, 
    0x08, 0xd1, 0x89, 0x7d, 0xe2, 0x17, 0xdc, 0xb3, 0xda, 0xbc, 0x3a, 0x9f, 0x84, 0x03, 0xd3, 0x2e, 
    0x68, 0xbe, 0xc1, 0x57, 0xcb, 0x2a, 0xe2, 0xd6, 0xcf, 0xc4, 0x7f, 0xbd, 0x53, 0x3f, 0xeb, 0x39, 
    0x98, 0x69, 0xb0, 0x40, 0x14, 0xbf, 0xf5, 0x5a, 0x23, 0x23, 0xf4, 0x4c, 0xf8, 0xf1, 0x03, 0x56, 
    0x6d, 0x7d, 0x1b, 0x93, 0xd7, 0x0f, 0xc1, 0x8c, 0x70, 0xe0, 0x2c, 0x55, 0x7e, 0xa1, 0xfc, 0x05, 
    0xe9, 0xd7, 0xea, 0xb1, 0x5c, 0x0f, 0x9b, 0xac, 0x6a, 0x2e, 0xb4, 0xc5, 0xbf, 0x41, 0x8f, 0xda, 
    0xfc, 0x85, 0xc6, 0xaa, 0x25, 0xe4, 0xb9, 0x9a, 0xc6, 0xd8, 0x9a, 0x31, 0x8a, 0x17, 0x8b, 0x8c, 
    0x4e, 0x20, 0xd9, 0x71, 0xfc, 0x66, 0x3a, 0xfd, 0x49, 0x95, 0x54, 0xa8, 0xaf, 0x42, 0x5e, 0xba, 
    0x26, 0xe6, 0xd3, 0xa0, 0xd2, 0x02, 0x3b, 0x51, 0x8b, 0x39, 0xd3, 0x97, 0xd2, 0xe4, 0xd1, 0x01, 
    0x65, 0xab, 0x8e, 0xa2, 0x80, 0x5b, 0x5e, 0xbb, 0x11, 0x7f, 0x50, 0x1b, 0x2b, 0x0d, 0x20, 0x40, 
    0xb5, 0xbf, 0xd1, 0x32, 0xfa, 0x25, 0xe1, 0x0d, 0x75, 0xfc, 0x11, 0xcf, 0x21, 0xdd, 0x45, 0x16, 
    0xe4, 0x56, 0x58, 0x49, 0x33, 0xca, 0xaf, 0xe3, 0x17, 0x7b, 0x7a, 0x8f, 0xb1, 0xec, 0x1c, 0x4d, 
    0xa2, 0xc2, 0xce, 0x8b, 0x19, 0x4b, 0xc0, 0xc4, 0x36, 0x6a, 0x7c, 0x5b, 0x89, 0x14, 0x98, 0xcb, 
    0xa9, 0xca, 0x66, 0xf2, 0xaa, 0xf9, 0x12, 0x40, 0x0e, 0x6a, 0x78, 0x4d, 0x1f, 0x54, 0x3c, 0x03, 
    0x7a, 0x91, 0xf5, 0xb7, 0x3d, 0xe2, 0xfc, 0x65, 0xb7, 0xaa, 0xa9, 0x39, 0x68, 0xa7, 0xdb, 0x29, 
    0xc1, 0x40, 0x0b, 0x4e, 0xfb, 0xce, 0x74, 0xa5, 0x46, 0xb9, 0x02, 0x03, 0x01, 0x00, 0x01, 0xa3, 
    0x81, 0xc2, 0x30, 0x81, 0xbf, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 
    0x60, 0x6e, 0x44, 0x94, 0xa8, 0xa2, 0x4e, 0x7a, 0x3e, 0xe2, 0x4b, 0x84, 0x5e, 0xec, 0x01, 0xc9, 
    0xa3, 0xf9, 0x69, 0xaf, 0x30, 0x1f, 0x06, 0x03, 0x55, 0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 
    0x14, 0x53, 0x77, 0xe0, 0xa2, 0xf2, 0x49, 0x38, 0xcf, 0x71, 0x58, 0x0a, 0x67, 0xa6, 0xc0, 0x17, 
    0xd7, 0xb5, 0xdc, 0x52, 0x4b, 0x30, 0x09, 0x06, 0x03, 0x55, 0x1d, 0x13, 0x04, 0x02, 0x30, 0x00, 
    0x30, 0x0b, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x04, 0x04, 0x03, 0x02, 0x05, 0xe0, 0x30, 0x1d, 0x06, 
    0x03, 0x55, 0x1d, 0x25, 0x04, 0x16, 0x30, 0x14, 0x06, 0x08, 0x2b, 0x06, 0x01, 0x05, 0x05, 0x07, 
    0x03, 0x01, 0x06, 0x08, 0x2b, 0x06, 0x01, 0x05, 0x05, 0x07, 0x03, 0x02, 0x30, 0x46, 0x06, 0x03, 
    0x55, 0x1d, 0x11, 0x04, 0x3f, 0x30, 0x3d, 0x82, 0x09, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x68, 0x6f, 
    0x73, 0x74, 0x82, 0x06, 0x64, 0x65, 0x62, 0x69, 0x61, 0x6e, 0x87, 0x04, 0x7f, 0x00, 0x00, 0x01, 
    0x87, 0x04, 0x00, 0x00, 0x00, 0x00, 0x86, 0x1c, 0x75, 0x72, 0x6e, 0x3a, 0x75, 0x6e, 0x63, 0x6f, 
    0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x64, 0x3a, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 
    0x74, 0x69, 0x6f, 0x6e, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 
    0x0b, 0x05, 0x00, 0x03, 0x82, 0x01, 0x01, 0x00, 0xa4, 0xc1, 0x4f, 0x0e, 0xfe, 0xce, 0x2d, 0x91, 
    0x8a, 0x51, 0x25, 0xd2, 0x6c, 0x07, 0x86, 0x95, 0xba, 0xc5, 0xe0, 0xad, 0x9b, 0x09, 0x3e, 0x7f, 
    0x36, 0xc4, 0xa8, 0x10, 0x5b, 0x33, 0x77, 0xe5, 0xb5, 0x3b, 0xd8, 0x98, 0x7c, 0x42, 0x05, 0xcb, 
    0xb7, 0x91, 0x07, 0x3f, 0x47, 0xff, 0x13, 0x15, 0x45, 0xff, 0x05, 0x03, 0x3d, 0xed, 0x63, 0x96, 
    0x3a, 0x5c, 0xf8, 0x59, 0xd0, 0xbc, 0x68, 0x8c, 0xfb, 0xf8, 0x29, 0x07, 0x76, 0x63, 0xa7, 0x39, 
    0xc1, 0x82, 0xc1, 0x10, 0x8b, 0x17, 0xf2, 0x1d, 0x14, 0xdd, 0x88, 0xe7, 0xdc, 0x2f, 0xa7, 0x9d, 
    0xa3, 0xaa, 0xfd, 0x1a, 0x70, 0xce, 0x57, 0xb5, 0x9f, 0xc3, 0x7b, 0xd0, 0xc0, 0x6f, 0x73, 0x81, 
    0x74, 0x41, 0x93, 0x0d, 0x0d, 0x1a, 0x95, 0xf6, 0xe4, 0x1c, 0x04, 0x2b, 0x37, 0x4f, 0xf9, 0x99, 
    0x82, 0x57, 0xf0, 0x4f, 0x14, 0xcb, 0x0f, 0x3d, 0x1a, 0x52, 0x69, 0x18, 0x3f, 0xbe, 0x1c, 0x1c, 
    0x1b, 0xca, 0xbd, 0xe7, 0xe0, 0x81, 0x44, 0x6d, 0x4a, 0x08, 0x8a, 0xe2, 0x7e, 0x59, 0x9f, 0x89, 
    0x44, 0x7e, 0x4d, 0xaf, 0x5a, 0x8e, 0xe8, 0xd2, 0x2e, 0x98, 0x72, 0x86, 0xef, 0x7b, 0xcf, 0x88, 
    0xd0, 0xe2, 0xd5, 0xd9, 0xd5, 0x19, 0xa2, 0x8c, 0xf4, 0x40, 0x98, 0x86, 0x32, 0x9f, 0x3e, 0x25, 
    0x05, 0xd0, 0xdc, 0xf8, 0x1a, 0x0f, 0xdf, 0xc0, 0x54, 0x46, 0x20, 0xbd, 0xd4, 0xf6, 0xf5, 0xdd, 
    0x10, 0x2e, 0xa7, 0x1a, 0xf4, 0xbb, 0xed, 0x5d, 0xf3, 0x1c, 0x96, 0x44, 0x81, 0x69, 0xd4, 0x0b, 
    0xbe, 0x59, 0x07, 0x1b, 0x7f, 0x93, 0xc3, 0x4e, 0x7b, 0x32, 0x51, 0xd0, 0x13, 0x47, 0x57, 0x52, 
    0xf0, 0x5c, 0x54, 0x36, 0x22, 0xb6, 0xf5, 0x67, 0xbb, 0xd3, 0xa6, 0x43, 0xf0, 0xca, 0x98, 0x91, 
    0xda, 0x31, 0x3e, 0xd2, 0x8c, 0xfe, 0xd7, 0x51  
    };

#define KEY_PEM_LENGTH 1679
UA_Byte KEY_PEM_DATA[1679] = {
    0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x42, 0x45, 0x47, 0x49, 0x4e, 0x20, 0x52, 0x53, 0x41, 0x20, 0x50,
    0x52, 0x49, 0x56, 0x41, 0x54, 0x45, 0x20, 0x4b, 0x45, 0x59, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x0a,
    0x4d, 0x49, 0x49, 0x45, 0x70, 0x51, 0x49, 0x42, 0x41, 0x41, 0x4b, 0x43, 0x41, 0x51, 0x45, 0x41,
    0x34, 0x4d, 0x6d, 0x52, 0x59, 0x73, 0x32, 0x52, 0x61, 0x48, 0x55, 0x73, 0x4d, 0x6e, 0x72, 0x64,
    0x38, 0x64, 0x5a, 0x6b, 0x64, 0x34, 0x74, 0x79, 0x6e, 0x68, 0x51, 0x71, 0x59, 0x67, 0x6a, 0x52,
    0x69, 0x58, 0x33, 0x69, 0x46, 0x39, 0x79, 0x7a, 0x32, 0x72, 0x77, 0x36, 0x6e, 0x34, 0x51, 0x44,
    0x0a, 0x30, 0x79, 0x35, 0x6f, 0x76, 0x73, 0x46, 0x58, 0x79, 0x79, 0x72, 0x69, 0x31, 0x73, 0x2f,
    0x45, 0x66, 0x37, 0x31, 0x54, 0x50, 0x2b, 0x73, 0x35, 0x6d, 0x47, 0x6d, 0x77, 0x51, 0x42, 0x53,
    0x2f, 0x39, 0x56, 0x6f, 0x6a, 0x49, 0x2f, 0x52, 0x4d, 0x2b, 0x50, 0x45, 0x44, 0x56, 0x6d, 0x31,
    0x39, 0x47, 0x35, 0x50, 0x58, 0x44, 0x38, 0x47, 0x4d, 0x63, 0x4f, 0x41, 0x73, 0x56, 0x58, 0x36,
    0x68, 0x0a, 0x2f, 0x41, 0x58, 0x70, 0x31, 0x2b, 0x71, 0x78, 0x58, 0x41, 0x2b, 0x62, 0x72, 0x47,
    0x6f, 0x75, 0x74, 0x4d, 0x57, 0x2f, 0x51, 0x59, 0x2f, 0x61, 0x2f, 0x49, 0x58, 0x47, 0x71, 0x69,
    0x58, 0x6b, 0x75, 0x5a, 0x72, 0x47, 0x32, 0x4a, 0x6f, 0x78, 0x69, 0x68, 0x65, 0x4c, 0x6a, 0x45,
    0x34, 0x67, 0x32, 0x58, 0x48, 0x38, 0x5a, 0x6a, 0x72, 0x39, 0x53, 0x5a, 0x56, 0x55, 0x71, 0x4b,
    0x39, 0x43, 0x0a, 0x58, 0x72, 0x6f, 0x6d, 0x35, 0x74, 0x4f, 0x67, 0x30, 0x67, 0x49, 0x37, 0x55,
    0x59, 0x73, 0x35, 0x30, 0x35, 0x66, 0x53, 0x35, 0x4e, 0x45, 0x42, 0x5a, 0x61, 0x75, 0x4f, 0x6f,
    0x6f, 0x42, 0x62, 0x58, 0x72, 0x73, 0x52, 0x66, 0x31, 0x41, 0x62, 0x4b, 0x77, 0x30, 0x67, 0x51,
    0x4c, 0x57, 0x2f, 0x30, 0x54, 0x4c, 0x36, 0x4a, 0x65, 0x45, 0x4e, 0x64, 0x66, 0x77, 0x52, 0x7a,
    0x79, 0x48, 0x64, 0x0a, 0x52, 0x52, 0x62, 0x6b, 0x56, 0x6c, 0x68, 0x4a, 0x4d, 0x38, 0x71, 0x76,
    0x34, 0x78, 0x64, 0x37, 0x65, 0x6f, 0x2b, 0x78, 0x37, 0x42, 0x78, 0x4e, 0x6f, 0x73, 0x4c, 0x4f,
    0x69, 0x78, 0x6c, 0x4c, 0x77, 0x4d, 0x51, 0x32, 0x61, 0x6e, 0x78, 0x62, 0x69, 0x52, 0x53, 0x59,
    0x79, 0x36, 0x6e, 0x4b, 0x5a, 0x76, 0x4b, 0x71, 0x2b, 0x52, 0x4a, 0x41, 0x44, 0x6d, 0x70, 0x34,
    0x54, 0x52, 0x39, 0x55, 0x0a, 0x50, 0x41, 0x4e, 0x36, 0x6b, 0x66, 0x57, 0x33, 0x50, 0x65, 0x4c,
    0x38, 0x5a, 0x62, 0x65, 0x71, 0x71, 0x54, 0x6c, 0x6f, 0x70, 0x39, 0x73, 0x70, 0x77, 0x55, 0x41,
    0x4c, 0x54, 0x76, 0x76, 0x4f, 0x64, 0x4b, 0x56, 0x47, 0x75, 0x51, 0x49, 0x44, 0x41, 0x51, 0x41,
    0x42, 0x41, 0x6f, 0x49, 0x42, 0x41, 0x51, 0x43, 0x30, 0x79, 0x41, 0x64, 0x67, 0x41, 0x64, 0x6d,
    0x32, 0x75, 0x37, 0x32, 0x4f, 0x0a, 0x33, 0x35, 0x66, 0x4e, 0x33, 0x6c, 0x47, 0x77, 0x66, 0x76,
    0x72, 0x77, 0x50, 0x57, 0x47, 0x55, 0x74, 0x47, 0x6a, 0x6f, 0x66, 0x64, 0x41, 0x75, 0x78, 0x72,
    0x58, 0x79, 0x37, 0x62, 0x7a, 0x72, 0x2b, 0x7a, 0x30, 0x6b, 0x51, 0x30, 0x66, 0x45, 0x57, 0x6a,
    0x52, 0x6b, 0x56, 0x68, 0x70, 0x58, 0x44, 0x6f, 0x4f, 0x48, 0x42, 0x46, 0x6d, 0x47, 0x70, 0x34,
    0x51, 0x4c, 0x6d, 0x72, 0x77, 0x2f, 0x0a, 0x33, 0x54, 0x42, 0x41, 0x66, 0x33, 0x79, 0x52, 0x64,
    0x76, 0x48, 0x4d, 0x70, 0x2f, 0x43, 0x36, 0x4f, 0x70, 0x59, 0x4b, 0x62, 0x73, 0x7a, 0x67, 0x68,
    0x42, 0x57, 0x52, 0x31, 0x67, 0x68, 0x78, 0x76, 0x63, 0x56, 0x43, 0x72, 0x66, 0x4c, 0x53, 0x54,
    0x70, 0x4c, 0x54, 0x61, 0x6b, 0x34, 0x56, 0x7a, 0x4e, 0x50, 0x42, 0x57, 0x4f, 0x51, 0x6e, 0x4d,
    0x79, 0x32, 0x34, 0x4e, 0x31, 0x4a, 0x2b, 0x0a, 0x46, 0x72, 0x6d, 0x72, 0x74, 0x39, 0x6e, 0x42,
    0x36, 0x38, 0x68, 0x35, 0x75, 0x64, 0x50, 0x6d, 0x52, 0x42, 0x4e, 0x52, 0x4c, 0x63, 0x59, 0x43,
    0x35, 0x65, 0x41, 0x38, 0x6f, 0x78, 0x57, 0x62, 0x53, 0x61, 0x36, 0x46, 0x76, 0x6f, 0x79, 0x45,
    0x2b, 0x59, 0x64, 0x64, 0x6b, 0x5a, 0x37, 0x30, 0x2b, 0x66, 0x4b, 0x4e, 0x67, 0x58, 0x64, 0x38,
    0x2f, 0x47, 0x41, 0x4a, 0x53, 0x45, 0x4d, 0x75, 0x0a, 0x75, 0x36, 0x2f, 0x4a, 0x31, 0x70, 0x41,
    0x74, 0x51, 0x49, 0x42, 0x5a, 0x76, 0x54, 0x73, 0x45, 0x32, 0x6c, 0x41, 0x71, 0x55, 0x2f, 0x58,
    0x41, 0x6c, 0x31, 0x51, 0x45, 0x46, 0x4c, 0x47, 0x4f, 0x30, 0x57, 0x74, 0x54, 0x6e, 0x71, 0x53,
    0x71, 0x58, 0x6d, 0x34, 0x63, 0x45, 0x57, 0x73, 0x4b, 0x78, 0x4f, 0x78, 0x62, 0x64, 0x36, 0x67,
    0x41, 0x67, 0x33, 0x66, 0x62, 0x39, 0x50, 0x73, 0x41, 0x0a, 0x39, 0x41, 0x5a, 0x58, 0x4a, 0x59,
    0x34, 0x63, 0x68, 0x37, 0x53, 0x2b, 0x75, 0x41, 0x51, 0x31, 0x6b, 0x32, 0x65, 0x71, 0x4e, 0x71,
    0x56, 0x69, 0x35, 0x50, 0x62, 0x4c, 0x79, 0x4b, 0x5a, 0x59, 0x64, 0x35, 0x62, 0x45, 0x62, 0x41,
    0x76, 0x49, 0x51, 0x65, 0x49, 0x32, 0x41, 0x5a, 0x53, 0x6c, 0x36, 0x55, 0x59, 0x58, 0x30, 0x77,
    0x73, 0x59, 0x66, 0x67, 0x61, 0x49, 0x6d, 0x33, 0x37, 0x64, 0x0a, 0x6b, 0x69, 0x44, 0x47, 0x34,
    0x33, 0x36, 0x78, 0x41, 0x6f, 0x47, 0x42, 0x41, 0x50, 0x57, 0x6d, 0x32, 0x6a, 0x4b, 0x35, 0x4e,
    0x32, 0x48, 0x70, 0x66, 0x4a, 0x6e, 0x33, 0x53, 0x6a, 0x66, 0x75, 0x55, 0x6a, 0x42, 0x50, 0x76,
    0x31, 0x64, 0x76, 0x2f, 0x69, 0x44, 0x63, 0x6f, 0x2f, 0x35, 0x52, 0x76, 0x33, 0x49, 0x54, 0x69,
    0x72, 0x48, 0x58, 0x6d, 0x58, 0x31, 0x6e, 0x71, 0x4e, 0x53, 0x77, 0x0a, 0x4e, 0x55, 0x42, 0x38,
    0x79, 0x4e, 0x77, 0x44, 0x61, 0x35, 0x43, 0x31, 0x5a, 0x51, 0x52, 0x2f, 0x6c, 0x34, 0x75, 0x6f,
    0x61, 0x53, 0x41, 0x45, 0x79, 0x30, 0x67, 0x35, 0x74, 0x31, 0x66, 0x67, 0x32, 0x62, 0x73, 0x56,
    0x34, 0x56, 0x6b, 0x57, 0x38, 0x2b, 0x47, 0x72, 0x6b, 0x65, 0x71, 0x4b, 0x69, 0x4b, 0x32, 0x4e,
    0x6f, 0x79, 0x52, 0x4b, 0x4e, 0x61, 0x58, 0x53, 0x4d, 0x68, 0x6c, 0x6d, 0x0a, 0x71, 0x4c, 0x73,
    0x79, 0x6e, 0x66, 0x53, 0x55, 0x6d, 0x63, 0x45, 0x75, 0x4b, 0x2f, 0x69, 0x59, 0x61, 0x6d, 0x35,
    0x79, 0x64, 0x39, 0x44, 0x4a, 0x2f, 0x46, 0x2f, 0x58, 0x61, 0x64, 0x45, 0x49, 0x45, 0x72, 0x2b,
    0x42, 0x77, 0x61, 0x45, 0x62, 0x4f, 0x30, 0x47, 0x77, 0x4a, 0x42, 0x45, 0x4b, 0x5a, 0x61, 0x75,
    0x42, 0x4f, 0x62, 0x50, 0x56, 0x41, 0x6f, 0x47, 0x42, 0x41, 0x4f, 0x70, 0x42, 0x0a, 0x74, 0x65,
    0x32, 0x73, 0x6f, 0x45, 0x50, 0x58, 0x33, 0x68, 0x35, 0x72, 0x6c, 0x62, 0x36, 0x49, 0x41, 0x71,
    0x38, 0x76, 0x75, 0x7a, 0x66, 0x33, 0x4c, 0x2f, 0x5a, 0x50, 0x6f, 0x4b, 0x70, 0x44, 0x41, 0x33,
    0x30, 0x7a, 0x33, 0x52, 0x35, 0x36, 0x75, 0x71, 0x41, 0x51, 0x64, 0x78, 0x39, 0x4b, 0x79, 0x59,
    0x68, 0x59, 0x6e, 0x59, 0x45, 0x36, 0x36, 0x4b, 0x79, 0x47, 0x4c, 0x34, 0x42, 0x73, 0x0a, 0x78,
    0x36, 0x44, 0x6c, 0x37, 0x59, 0x32, 0x51, 0x71, 0x61, 0x63, 0x32, 0x49, 0x39, 0x65, 0x31, 0x69,
    0x66, 0x79, 0x74, 0x54, 0x61, 0x34, 0x4f, 0x37, 0x4e, 0x7a, 0x6e, 0x66, 0x6d, 0x6e, 0x2b, 0x59,
    0x6b, 0x75, 0x42, 0x2f, 0x6c, 0x4b, 0x42, 0x64, 0x32, 0x6f, 0x31, 0x71, 0x31, 0x4a, 0x76, 0x56,
    0x6b, 0x46, 0x73, 0x56, 0x7a, 0x31, 0x31, 0x6b, 0x68, 0x52, 0x43, 0x6f, 0x73, 0x6c, 0x51, 0x0a,
    0x55, 0x6c, 0x65, 0x66, 0x4a, 0x6a, 0x7a, 0x4e, 0x59, 0x61, 0x6e, 0x61, 0x6d, 0x79, 0x7a, 0x61,
    0x77, 0x64, 0x41, 0x6d, 0x42, 0x35, 0x41, 0x56, 0x6a, 0x49, 0x48, 0x69, 0x33, 0x73, 0x43, 0x59,
    0x57, 0x4a, 0x32, 0x57, 0x44, 0x38, 0x31, 0x56, 0x41, 0x6f, 0x47, 0x42, 0x41, 0x49, 0x66, 0x37,
    0x2b, 0x48, 0x66, 0x78, 0x7a, 0x66, 0x57, 0x32, 0x6f, 0x64, 0x49, 0x39, 0x63, 0x57, 0x6c, 0x71,
    0x0a, 0x31, 0x54, 0x61, 0x48, 0x50, 0x74, 0x32, 0x78, 0x55, 0x6c, 0x56, 0x77, 0x72, 0x70, 0x75,
    0x66, 0x4e, 0x30, 0x4a, 0x34, 0x44, 0x4f, 0x51, 0x4c, 0x2f, 0x4a, 0x7a, 0x4f, 0x49, 0x45, 0x69,
    0x30, 0x7a, 0x70, 0x58, 0x48, 0x50, 0x67, 0x32, 0x46, 0x47, 0x79, 0x74, 0x39, 0x4c, 0x74, 0x47,
    0x42, 0x72, 0x43, 0x75, 0x55, 0x61, 0x37, 0x56, 0x63, 0x30, 0x67, 0x64, 0x47, 0x59, 0x2f, 0x63,
    0x53, 0x0a, 0x73, 0x70, 0x54, 0x39, 0x4e, 0x4d, 0x54, 0x7a, 0x6a, 0x73, 0x67, 0x54, 0x43, 0x50,
    0x42, 0x30, 0x42, 0x64, 0x74, 0x46, 0x4e, 0x39, 0x56, 0x6a, 0x2b, 0x7a, 0x53, 0x7a, 0x47, 0x69,
    0x61, 0x7a, 0x6a, 0x4a, 0x34, 0x73, 0x46, 0x41, 0x4b, 0x4c, 0x72, 0x46, 0x32, 0x6a, 0x4b, 0x4a,
    0x59, 0x79, 0x45, 0x57, 0x44, 0x59, 0x6e, 0x76, 0x6b, 0x47, 0x68, 0x31, 0x32, 0x71, 0x79, 0x70,
    0x6e, 0x37, 0x0a, 0x52, 0x52, 0x32, 0x63, 0x50, 0x38, 0x72, 0x6d, 0x58, 0x7a, 0x51, 0x71, 0x78,
    0x4a, 0x78, 0x6d, 0x54, 0x41, 0x66, 0x58, 0x76, 0x6c, 0x43, 0x4e, 0x41, 0x6f, 0x47, 0x41, 0x55,
    0x64, 0x75, 0x57, 0x62, 0x44, 0x41, 0x33, 0x62, 0x4a, 0x32, 0x68, 0x51, 0x33, 0x59, 0x4b, 0x78,
    0x4b, 0x4b, 0x59, 0x64, 0x59, 0x6b, 0x7a, 0x58, 0x64, 0x49, 0x6c, 0x30, 0x32, 0x64, 0x74, 0x32,
    0x44, 0x46, 0x45, 0x0a, 0x70, 0x64, 0x71, 0x61, 0x75, 0x51, 0x7a, 0x66, 0x37, 0x42, 0x44, 0x30,
    0x33, 0x31, 0x31, 0x74, 0x34, 0x52, 0x51, 0x2b, 0x4c, 0x61, 0x74, 0x64, 0x4a, 0x50, 0x52, 0x61,
    0x34, 0x77, 0x43, 0x67, 0x48, 0x59, 0x78, 0x62, 0x48, 0x32, 0x33, 0x65, 0x71, 0x73, 0x79, 0x54,
    0x5a, 0x38, 0x78, 0x4c, 0x4a, 0x4a, 0x32, 0x57, 0x6d, 0x47, 0x30, 0x6b, 0x76, 0x65, 0x69, 0x79,
    0x31, 0x75, 0x30, 0x4b, 0x0a, 0x67, 0x69, 0x49, 0x78, 0x73, 0x62, 0x6b, 0x46, 0x39, 0x6e, 0x6f,
    0x38, 0x6e, 0x4c, 0x6a, 0x46, 0x4a, 0x6d, 0x56, 0x71, 0x63, 0x74, 0x4b, 0x44, 0x73, 0x6b, 0x71,
    0x36, 0x77, 0x61, 0x67, 0x73, 0x72, 0x65, 0x75, 0x79, 0x47, 0x2b, 0x73, 0x55, 0x35, 0x70, 0x71,
    0x36, 0x51, 0x4d, 0x6c, 0x4d, 0x6b, 0x71, 0x54, 0x48, 0x58, 0x63, 0x54, 0x35, 0x37, 0x57, 0x56,
    0x4f, 0x75, 0x33, 0x52, 0x41, 0x0a, 0x2b, 0x77, 0x67, 0x32, 0x43, 0x32, 0x55, 0x43, 0x67, 0x59,
    0x45, 0x41, 0x36, 0x32, 0x41, 0x42, 0x49, 0x53, 0x4b, 0x68, 0x33, 0x6f, 0x6c, 0x69, 0x2b, 0x6d,
    0x67, 0x44, 0x43, 0x66, 0x47, 0x6d, 0x46, 0x50, 0x43, 0x2b, 0x39, 0x33, 0x45, 0x36, 0x41, 0x59,
    0x55, 0x66, 0x4c, 0x49, 0x62, 0x65, 0x53, 0x76, 0x73, 0x31, 0x46, 0x73, 0x53, 0x45, 0x49, 0x6f,
    0x4e, 0x4a, 0x36, 0x77, 0x33, 0x33, 0x0a, 0x4d, 0x30, 0x65, 0x50, 0x6c, 0x6a, 0x63, 0x79, 0x30,
    0x39, 0x4c, 0x73, 0x36, 0x67, 0x2f, 0x51, 0x33, 0x67, 0x30, 0x6e, 0x6e, 0x73, 0x48, 0x78, 0x34,
    0x44, 0x6d, 0x6d, 0x50, 0x6d, 0x7a, 0x55, 0x4f, 0x64, 0x2f, 0x65, 0x76, 0x55, 0x79, 0x34, 0x35,
    0x37, 0x64, 0x4f, 0x4b, 0x6a, 0x4b, 0x53, 0x67, 0x39, 0x4d, 0x53, 0x75, 0x61, 0x47, 0x52, 0x55,
    0x6b, 0x59, 0x6b, 0x57, 0x41, 0x55, 0x31, 0x0a, 0x49, 0x6c, 0x38, 0x51, 0x50, 0x42, 0x4e, 0x62,
    0x76, 0x6b, 0x64, 0x65, 0x76, 0x34, 0x58, 0x57, 0x72, 0x50, 0x79, 0x37, 0x32, 0x5a, 0x48, 0x35,
    0x55, 0x49, 0x2f, 0x38, 0x77, 0x69, 0x79, 0x42, 0x58, 0x4b, 0x58, 0x44, 0x77, 0x68, 0x57, 0x2b,
    0x39, 0x48, 0x4c, 0x39, 0x54, 0x66, 0x41, 0x51, 0x62, 0x2b, 0x57, 0x2f, 0x6a, 0x4c, 0x45, 0x3d,
    0x0a, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x45, 0x4e, 0x44, 0x20, 0x52, 0x53, 0x41, 0x20, 0x50, 0x52,
    0x49, 0x56, 0x41, 0x54, 0x45, 0x20, 0x4b, 0x45, 0x59, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x0a
};

#define CERT_PEM_LENGTH 1367
UA_Byte CERT_PEM_DATA[1367] = {
    0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x42, 0x45, 0x47, 0x49, 0x4e, 0x20, 0x43, 0x45, 0x52, 0x54, 0x49,
    0x46, 0x49, 0x43, 0x41, 0x54, 0x45, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x0a, 0x4d, 0x49, 0x49, 0x44,
    0x78, 0x44, 0x43, 0x43, 0x41, 0x71, 0x79, 0x67, 0x41, 0x77, 0x49, 0x42, 0x41, 0x67, 0x49, 0x4a,
    0x41, 0x4b, 0x63, 0x58, 0x52, 0x43, 0x2b, 0x4f, 0x61, 0x33, 0x53, 0x36, 0x4d, 0x41, 0x30, 0x47,
    0x43, 0x53, 0x71, 0x47, 0x53, 0x49, 0x62, 0x33, 0x44, 0x51, 0x45, 0x42, 0x43, 0x77, 0x55, 0x41,
    0x4d, 0x44, 0x6b, 0x78, 0x43, 0x7a, 0x41, 0x4a, 0x42, 0x67, 0x4e, 0x56, 0x0a, 0x42, 0x41, 0x59,
    0x54, 0x41, 0x6b, 0x52, 0x46, 0x4d, 0x52, 0x49, 0x77, 0x45, 0x41, 0x59, 0x44, 0x56, 0x51, 0x51,
    0x4b, 0x44, 0x41, 0x6c, 0x76, 0x63, 0x47, 0x56, 0x75, 0x4e, 0x6a, 0x49, 0x31, 0x4e, 0x44, 0x45,
    0x78, 0x46, 0x6a, 0x41, 0x55, 0x42, 0x67, 0x4e, 0x56, 0x42, 0x41, 0x4d, 0x4d, 0x44, 0x57, 0x39,
    0x77, 0x5a, 0x57, 0x34, 0x32, 0x4d, 0x6a, 0x55, 0x30, 0x4d, 0x53, 0x35, 0x76, 0x0a, 0x63, 0x6d,
    0x63, 0x77, 0x48, 0x68, 0x63, 0x4e, 0x4d, 0x54, 0x67, 0x77, 0x4d, 0x7a, 0x49, 0x34, 0x4d, 0x44,
    0x67, 0x7a, 0x4d, 0x7a, 0x55, 0x33, 0x57, 0x68, 0x63, 0x4e, 0x4d, 0x6a, 0x67, 0x77, 0x4d, 0x7a,
    0x49, 0x31, 0x4d, 0x44, 0x67, 0x7a, 0x4d, 0x7a, 0x55, 0x33, 0x57, 0x6a, 0x42, 0x46, 0x4d, 0x51,
    0x73, 0x77, 0x43, 0x51, 0x59, 0x44, 0x56, 0x51, 0x51, 0x47, 0x45, 0x77, 0x4a, 0x45, 0x0a, 0x52,
    0x54, 0x45, 0x53, 0x4d, 0x42, 0x41, 0x47, 0x41, 0x31, 0x55, 0x45, 0x43, 0x67, 0x77, 0x4a, 0x62,
    0x33, 0x42, 0x6c, 0x62, 0x6a, 0x59, 0x79, 0x4e, 0x54, 0x51, 0x78, 0x4d, 0x53, 0x49, 0x77, 0x49,
    0x41, 0x59, 0x44, 0x56, 0x51, 0x51, 0x44, 0x44, 0x42, 0x6c, 0x76, 0x63, 0x47, 0x56, 0x75, 0x4e,
    0x6a, 0x49, 0x31, 0x4e, 0x44, 0x46, 0x54, 0x5a, 0x58, 0x4a, 0x32, 0x5a, 0x58, 0x4a, 0x41, 0x0a,
    0x62, 0x47, 0x39, 0x6a, 0x59, 0x57, 0x78, 0x6f, 0x62, 0x33, 0x4e, 0x30, 0x4d, 0x49, 0x49, 0x42,
    0x49, 0x6a, 0x41, 0x4e, 0x42, 0x67, 0x6b, 0x71, 0x68, 0x6b, 0x69, 0x47, 0x39, 0x77, 0x30, 0x42,
    0x41, 0x51, 0x45, 0x46, 0x41, 0x41, 0x4f, 0x43, 0x41, 0x51, 0x38, 0x41, 0x4d, 0x49, 0x49, 0x42,
    0x43, 0x67, 0x4b, 0x43, 0x41, 0x51, 0x45, 0x41, 0x34, 0x4d, 0x6d, 0x52, 0x59, 0x73, 0x32, 0x52,
    0x0a, 0x61, 0x48, 0x55, 0x73, 0x4d, 0x6e, 0x72, 0x64, 0x38, 0x64, 0x5a, 0x6b, 0x64, 0x34, 0x74,
    0x79, 0x6e, 0x68, 0x51, 0x71, 0x59, 0x67, 0x6a, 0x52, 0x69, 0x58, 0x33, 0x69, 0x46, 0x39, 0x79,
    0x7a, 0x32, 0x72, 0x77, 0x36, 0x6e, 0x34, 0x51, 0x44, 0x30, 0x79, 0x35, 0x6f, 0x76, 0x73, 0x46,
    0x58, 0x79, 0x79, 0x72, 0x69, 0x31, 0x73, 0x2f, 0x45, 0x66, 0x37, 0x31, 0x54, 0x50, 0x2b, 0x73,
    0x35, 0x0a, 0x6d, 0x47, 0x6d, 0x77, 0x51, 0x42, 0x53, 0x2f, 0x39, 0x56, 0x6f, 0x6a, 0x49, 0x2f,
    0x52, 0x4d, 0x2b, 0x50, 0x45, 0x44, 0x56, 0x6d, 0x31, 0x39, 0x47, 0x35, 0x50, 0x58, 0x44, 0x38,
    0x47, 0x4d, 0x63, 0x4f, 0x41, 0x73, 0x56, 0x58, 0x36, 0x68, 0x2f, 0x41, 0x58, 0x70, 0x31, 0x2b,
    0x71, 0x78, 0x58, 0x41, 0x2b, 0x62, 0x72, 0x47, 0x6f, 0x75, 0x74, 0x4d, 0x57, 0x2f, 0x51, 0x59,
    0x2f, 0x61, 0x0a, 0x2f, 0x49, 0x58, 0x47, 0x71, 0x69, 0x58, 0x6b, 0x75, 0x5a, 0x72, 0x47, 0x32,
    0x4a, 0x6f, 0x78, 0x69, 0x68, 0x65, 0x4c, 0x6a, 0x45, 0x34, 0x67, 0x32, 0x58, 0x48, 0x38, 0x5a,
    0x6a, 0x72, 0x39, 0x53, 0x5a, 0x56, 0x55, 0x71, 0x4b, 0x39, 0x43, 0x58, 0x72, 0x6f, 0x6d, 0x35,
    0x74, 0x4f, 0x67, 0x30, 0x67, 0x49, 0x37, 0x55, 0x59, 0x73, 0x35, 0x30, 0x35, 0x66, 0x53, 0x35,
    0x4e, 0x45, 0x42, 0x0a, 0x5a, 0x61, 0x75, 0x4f, 0x6f, 0x6f, 0x42, 0x62, 0x58, 0x72, 0x73, 0x52,
    0x66, 0x31, 0x41, 0x62, 0x4b, 0x77, 0x30, 0x67, 0x51, 0x4c, 0x57, 0x2f, 0x30, 0x54, 0x4c, 0x36,
    0x4a, 0x65, 0x45, 0x4e, 0x64, 0x66, 0x77, 0x52, 0x7a, 0x79, 0x48, 0x64, 0x52, 0x52, 0x62, 0x6b,
    0x56, 0x6c, 0x68, 0x4a, 0x4d, 0x38, 0x71, 0x76, 0x34, 0x78, 0x64, 0x37, 0x65, 0x6f, 0x2b, 0x78,
    0x37, 0x42, 0x78, 0x4e, 0x0a, 0x6f, 0x73, 0x4c, 0x4f, 0x69, 0x78, 0x6c, 0x4c, 0x77, 0x4d, 0x51,
    0x32, 0x61, 0x6e, 0x78, 0x62, 0x69, 0x52, 0x53, 0x59, 0x79, 0x36, 0x6e, 0x4b, 0x5a, 0x76, 0x4b,
    0x71, 0x2b, 0x52, 0x4a, 0x41, 0x44, 0x6d, 0x70, 0x34, 0x54, 0x52, 0x39, 0x55, 0x50, 0x41, 0x4e,
    0x36, 0x6b, 0x66, 0x57, 0x33, 0x50, 0x65, 0x4c, 0x38, 0x5a, 0x62, 0x65, 0x71, 0x71, 0x54, 0x6c,
    0x6f, 0x70, 0x39, 0x73, 0x70, 0x0a, 0x77, 0x55, 0x41, 0x4c, 0x54, 0x76, 0x76, 0x4f, 0x64, 0x4b,
    0x56, 0x47, 0x75, 0x51, 0x49, 0x44, 0x41, 0x51, 0x41, 0x42, 0x6f, 0x34, 0x48, 0x43, 0x4d, 0x49,
    0x47, 0x2f, 0x4d, 0x42, 0x30, 0x47, 0x41, 0x31, 0x55, 0x64, 0x44, 0x67, 0x51, 0x57, 0x42, 0x42,
    0x52, 0x67, 0x62, 0x6b, 0x53, 0x55, 0x71, 0x4b, 0x4a, 0x4f, 0x65, 0x6a, 0x37, 0x69, 0x53, 0x34,
    0x52, 0x65, 0x37, 0x41, 0x48, 0x4a, 0x0a, 0x6f, 0x2f, 0x6c, 0x70, 0x72, 0x7a, 0x41, 0x66, 0x42,
    0x67, 0x4e, 0x56, 0x48, 0x53, 0x4d, 0x45, 0x47, 0x44, 0x41, 0x57, 0x67, 0x42, 0x52, 0x54, 0x64,
    0x2b, 0x43, 0x69, 0x38, 0x6b, 0x6b, 0x34, 0x7a, 0x33, 0x46, 0x59, 0x43, 0x6d, 0x65, 0x6d, 0x77,
    0x42, 0x66, 0x58, 0x74, 0x64, 0x78, 0x53, 0x53, 0x7a, 0x41, 0x4a, 0x42, 0x67, 0x4e, 0x56, 0x48,
    0x52, 0x4d, 0x45, 0x41, 0x6a, 0x41, 0x41, 0x0a, 0x4d, 0x41, 0x73, 0x47, 0x41, 0x31, 0x55, 0x64,
    0x44, 0x77, 0x51, 0x45, 0x41, 0x77, 0x49, 0x46, 0x34, 0x44, 0x41, 0x64, 0x42, 0x67, 0x4e, 0x56,
    0x48, 0x53, 0x55, 0x45, 0x46, 0x6a, 0x41, 0x55, 0x42, 0x67, 0x67, 0x72, 0x42, 0x67, 0x45, 0x46,
    0x42, 0x51, 0x63, 0x44, 0x41, 0x51, 0x59, 0x49, 0x4b, 0x77, 0x59, 0x42, 0x42, 0x51, 0x55, 0x48,
    0x41, 0x77, 0x49, 0x77, 0x52, 0x67, 0x59, 0x44, 0x0a, 0x56, 0x52, 0x30, 0x52, 0x42, 0x44, 0x38,
    0x77, 0x50, 0x59, 0x49, 0x4a, 0x62, 0x47, 0x39, 0x6a, 0x59, 0x57, 0x78, 0x6f, 0x62, 0x33, 0x4e,
    0x30, 0x67, 0x67, 0x5a, 0x6b, 0x5a, 0x57, 0x4a, 0x70, 0x59, 0x57, 0x36, 0x48, 0x42, 0x48, 0x38,
    0x41, 0x41, 0x41, 0x47, 0x48, 0x42, 0x41, 0x41, 0x41, 0x41, 0x41, 0x43, 0x47, 0x48, 0x48, 0x56,
    0x79, 0x62, 0x6a, 0x70, 0x31, 0x62, 0x6d, 0x4e, 0x76, 0x0a, 0x62, 0x6d, 0x5a, 0x70, 0x5a, 0x33,
    0x56, 0x79, 0x5a, 0x57, 0x51, 0x36, 0x59, 0x58, 0x42, 0x77, 0x62, 0x47, 0x6c, 0x6a, 0x59, 0x58,
    0x52, 0x70, 0x62, 0x32, 0x34, 0x77, 0x44, 0x51, 0x59, 0x4a, 0x4b, 0x6f, 0x5a, 0x49, 0x68, 0x76,
    0x63, 0x4e, 0x41, 0x51, 0x45, 0x4c, 0x42, 0x51, 0x41, 0x44, 0x67, 0x67, 0x45, 0x42, 0x41, 0x4b,
    0x54, 0x42, 0x54, 0x77, 0x37, 0x2b, 0x7a, 0x69, 0x32, 0x52, 0x0a, 0x69, 0x6c, 0x45, 0x6c, 0x30,
    0x6d, 0x77, 0x48, 0x68, 0x70, 0x57, 0x36, 0x78, 0x65, 0x43, 0x74, 0x6d, 0x77, 0x6b, 0x2b, 0x66,
    0x7a, 0x62, 0x45, 0x71, 0x42, 0x42, 0x62, 0x4d, 0x33, 0x66, 0x6c, 0x74, 0x54, 0x76, 0x59, 0x6d,
    0x48, 0x78, 0x43, 0x42, 0x63, 0x75, 0x33, 0x6b, 0x51, 0x63, 0x2f, 0x52, 0x2f, 0x38, 0x54, 0x46,
    0x55, 0x58, 0x2f, 0x42, 0x51, 0x4d, 0x39, 0x37, 0x57, 0x4f, 0x57, 0x0a, 0x4f, 0x6c, 0x7a, 0x34,
    0x57, 0x64, 0x43, 0x38, 0x61, 0x49, 0x7a, 0x37, 0x2b, 0x43, 0x6b, 0x48, 0x64, 0x6d, 0x4f, 0x6e,
    0x4f, 0x63, 0x47, 0x43, 0x77, 0x52, 0x43, 0x4c, 0x46, 0x2f, 0x49, 0x64, 0x46, 0x4e, 0x32, 0x49,
    0x35, 0x39, 0x77, 0x76, 0x70, 0x35, 0x32, 0x6a, 0x71, 0x76, 0x30, 0x61, 0x63, 0x4d, 0x35, 0x58,
    0x74, 0x5a, 0x2f, 0x44, 0x65, 0x39, 0x44, 0x41, 0x62, 0x33, 0x4f, 0x42, 0x0a, 0x64, 0x45, 0x47,
    0x54, 0x44, 0x51, 0x30, 0x61, 0x6c, 0x66, 0x62, 0x6b, 0x48, 0x41, 0x51, 0x72, 0x4e, 0x30, 0x2f,
    0x35, 0x6d, 0x59, 0x4a, 0x58, 0x38, 0x45, 0x38, 0x55, 0x79, 0x77, 0x38, 0x39, 0x47, 0x6c, 0x4a,
    0x70, 0x47, 0x44, 0x2b, 0x2b, 0x48, 0x42, 0x77, 0x62, 0x79, 0x72, 0x33, 0x6e, 0x34, 0x49, 0x46,
    0x45, 0x62, 0x55, 0x6f, 0x49, 0x69, 0x75, 0x4a, 0x2b, 0x57, 0x5a, 0x2b, 0x4a, 0x0a, 0x52, 0x48,
    0x35, 0x4e, 0x72, 0x31, 0x71, 0x4f, 0x36, 0x4e, 0x49, 0x75, 0x6d, 0x48, 0x4b, 0x47, 0x37, 0x33,
    0x76, 0x50, 0x69, 0x4e, 0x44, 0x69, 0x31, 0x64, 0x6e, 0x56, 0x47, 0x61, 0x4b, 0x4d, 0x39, 0x45,
    0x43, 0x59, 0x68, 0x6a, 0x4b, 0x66, 0x50, 0x69, 0x55, 0x46, 0x30, 0x4e, 0x7a, 0x34, 0x47, 0x67,
    0x2f, 0x66, 0x77, 0x46, 0x52, 0x47, 0x49, 0x4c, 0x33, 0x55, 0x39, 0x76, 0x58, 0x64, 0x0a, 0x45,
    0x43, 0x36, 0x6e, 0x47, 0x76, 0x53, 0x37, 0x37, 0x56, 0x33, 0x7a, 0x48, 0x4a, 0x5a, 0x45, 0x67,
    0x57, 0x6e, 0x55, 0x43, 0x37, 0x35, 0x5a, 0x42, 0x78, 0x74, 0x2f, 0x6b, 0x38, 0x4e, 0x4f, 0x65,
    0x7a, 0x4a, 0x52, 0x30, 0x42, 0x4e, 0x48, 0x56, 0x31, 0x4c, 0x77, 0x58, 0x46, 0x51, 0x32, 0x49,
    0x72, 0x62, 0x31, 0x5a, 0x37, 0x76, 0x54, 0x70, 0x6b, 0x50, 0x77, 0x79, 0x70, 0x69, 0x52, 0x0a,
    0x32, 0x6a, 0x45, 0x2b, 0x30, 0x6f, 0x7a, 0x2b, 0x31, 0x31, 0x45, 0x3d, 0x0a, 0x2d, 0x2d, 0x2d,
    0x2d, 0x2d, 0x45, 0x4e, 0x44, 0x20, 0x43, 0x45, 0x52, 0x54, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54,
    0x45, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x0a
};

_UA_END_DECLS

#endif /* CERTIFICATES_H_ */
